/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.search;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.actions.watch.search.SearchWatchRequest;
import com.floragunn.signals.actions.watch.search.SearchWatchResponse;
import com.floragunn.signals.watch.Watch;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchWatchAction
extends HandledTransportAction<SearchWatchRequest, SearchWatchResponse> {
    private final Signals signals;
    private final Client client;
    private final ThreadPool threadPool;

    @Inject
    public TransportSearchWatchAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:tenant:signals:watch/search", transportService, actionFilters, SearchWatchRequest::new);
        this.signals = signals;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, SearchWatchRequest request, final ActionListener<SearchWatchResponse> listener) {
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                throw new Exception("No user set");
            }
            SignalsTenant signalsTenant = this.signals.getTenant(user);
            if (signalsTenant == null) {
                throw new Exception("Unknown tenant: " + user.getRequestedTenant());
            }
            Object remoteAddress = threadContext.getTransient("_sg_remote_address");
            Object origin = threadContext.getTransient("_sg_origin");
            try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
                SearchSourceBuilder searchSourceBuilder;
                threadContext.putHeader("_sg_conf_request", "true");
                threadContext.putTransient("_sg_user", (Object)user);
                threadContext.putTransient("_sg_remote_address", remoteAddress);
                threadContext.putTransient("_sg_origin", origin);
                SearchRequest searchRequest = new SearchRequest(new String[]{signalsTenant.getConfigIndexName()});
                if (request.getScroll() != null) {
                    searchRequest.scroll(request.getScroll());
                }
                if ((searchSourceBuilder = request.getSearchSourceBuilder()) == null) {
                    searchSourceBuilder = new SearchSourceBuilder();
                    searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"_tenant", (String)signalsTenant.getName()));
                } else {
                    QueryBuilder originalQuery = searchSourceBuilder.query();
                    BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"_tenant", (String)signalsTenant.getName()));
                    if (originalQuery != null) {
                        newQuery.must(originalQuery);
                    }
                    searchSourceBuilder.query((QueryBuilder)newQuery);
                }
                if (request.getFrom() != -1) {
                    searchSourceBuilder.from(request.getFrom());
                }
                if (request.getSize() != -1) {
                    searchSourceBuilder.size(request.getSize());
                }
                searchSourceBuilder.fetchSource(Watch.HiddenAttributes.FETCH_SOURCE_CONTEXT);
                searchRequest.source(searchSourceBuilder);
                this.client.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                    public void onResponse(SearchResponse response) {
                        listener.onResponse((Object)new SearchWatchResponse(response));
                    }

                    public void onFailure(Exception e) {
                        listener.onFailure(e);
                    }
                });
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

